package com.ejie.ab04b.util.digitalizacion;

import java.io.Serializable;

import javax.xml.parsers.ParserConfigurationException;

import com.ejie.ab04b.constantes.ConstantesDigitalizacion;
import com.ejie.ab04b.util.XmlUtils;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public class ConfigDigitalizacion implements Serializable {

	private static final long serialVersionUID = 1L;

	private String integrationToken;
	private String urlADFileUpload;
	private String idSigningCertificate;
	private String documentalType;
	private String auditUser;
	private String acl;
	private String title;
	private String objectName;
	private String ejgvExpediente;
	private String ejgvTipoIndexacion;
	private String ejgvSerie;
	private String ejgvOrigen;
	private String javascriptResult;

	/**
	 * Instantiates a new config digitalizacion.
	 */
	public ConfigDigitalizacion() {

	}

	/**
	 *  String.
	 *
	 * @return the integration token
	 */
	public String getIntegrationToken() {
		return this.integrationToken;
	}

	/**
	 *  integrationToken
	 *            String.
	 *
	 * @param integrationToken the new integration token
	 */
	public void setIntegrationToken(String integrationToken) {
		this.integrationToken = integrationToken;
	}

	/**
	 *  String.
	 *
	 * @return the url AD file upload
	 */
	public String getUrlADFileUpload() {
		return this.urlADFileUpload;
	}

	/**
	 *  urlADFileUpload
	 *            String.
	 *
	 * @param urlADFileUpload the new url AD file upload
	 */
	public void setUrlADFileUpload(String urlADFileUpload) {
		this.urlADFileUpload = urlADFileUpload;
	}

	/**
	 *  String.
	 *
	 * @return the id signing certificate
	 */
	public String getIdSigningCertificate() {
		return this.idSigningCertificate;
	}

	/**
	 *  idSigningCertificate
	 *            String.
	 *
	 * @param idSigningCertificate the new id signing certificate
	 */
	public void setIdSigningCertificate(String idSigningCertificate) {
		this.idSigningCertificate = idSigningCertificate;
	}

	/**
	 *  String.
	 *
	 * @return the documental type
	 */
	public String getDocumentalType() {
		return this.documentalType;
	}

	/**
	 *  documentalType
	 *            String.
	 *
	 * @param documentalType the new documental type
	 */
	public void setDocumentalType(String documentalType) {
		this.documentalType = documentalType;
	}

	/**
	 *  String.
	 *
	 * @return the audit user
	 */
	public String getAuditUser() {
		return this.auditUser;
	}

	/**
	 *  auditUser
	 *            String.
	 *
	 * @param auditUser the new audit user
	 */
	public void setAuditUser(String auditUser) {
		this.auditUser = auditUser;
	}

	/**
	 *  String.
	 *
	 * @return the title
	 */
	public String getTitle() {
		return this.title;
	}

	/**
	 *  title
	 *            String.
	 *
	 * @param title the new title
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 *  String.
	 *
	 * @return the object name
	 */
	public String getObjectName() {
		return this.objectName;
	}

	/**
	 *  objectName
	 *            String.
	 *
	 * @param objectName the new object name
	 */
	public void setObjectName(String objectName) {
		this.objectName = objectName;
	}

	/**
	 *  String.
	 *
	 * @return the ejgv serie
	 */
	public String getEjgvSerie() {
		return this.ejgvSerie;
	}

	/**
	 *  ejgvSerie
	 *            String.
	 *
	 * @param ejgvSerie the new ejgv serie
	 */
	public void setEjgvSerie(String ejgvSerie) {
		this.ejgvSerie = ejgvSerie;
	}

	/**
	 *  String.
	 *
	 * @return the ejgv origen
	 */
	public String getEjgvOrigen() {
		return this.ejgvOrigen;
	}

	/**
	 *  ejgvOrigen
	 *            String.
	 *
	 * @param ejgvOrigen the new ejgv origen
	 */
	public void setEjgvOrigen(String ejgvOrigen) {
		this.ejgvOrigen = ejgvOrigen;
	}

	/**
	 *  String.
	 *
	 * @return the javascript result
	 */
	public String getJavascriptResult() {
		return this.javascriptResult;
	}

	/**
	 *  javascriptResult
	 *            String.
	 *
	 * @param javascriptResult the new javascript result
	 */
	public void setJavascriptResult(String javascriptResult) {
		this.javascriptResult = javascriptResult;
	}

	/**
	 *  String.
	 *
	 * @return the acl
	 */
	public String getAcl() {
		return this.acl;
	}

	/**
	 *  acl
	 *            String.
	 *
	 * @param acl the new acl
	 */
	public void setAcl(String acl) {
		this.acl = acl;
	}

	/**
	 *  String.
	 *
	 * @return the ejgv expediente
	 */
	public String getEjgvExpediente() {
		return this.ejgvExpediente;
	}

	/**
	 *  ejgvExpediente
	 *            String.
	 *
	 * @param ejgvExpediente the new ejgv expediente
	 */
	public void setEjgvExpediente(String ejgvExpediente) {
		this.ejgvExpediente = ejgvExpediente;
	}

	/**
	 *  String.
	 *
	 * @return the ejgv tipo indexacion
	 */
	public String getEjgvTipoIndexacion() {
		return this.ejgvTipoIndexacion;
	}

	/**
	 *  ejgvTipoIndexacion
	 *            String.
	 *
	 * @param ejgvTipoIndexacion the new ejgv tipo indexacion
	 */
	public void setEjgvTipoIndexacion(String ejgvTipoIndexacion) {
		this.ejgvTipoIndexacion = ejgvTipoIndexacion;
	}

	/**
	 *  String.
	 *
	 * @return the XML to applet
	 * @throws ParserConfigurationException             ParserConfigurationException
	 */
	public String getXMLToApplet() throws ParserConfigurationException {

		StringBuffer doc = new StringBuffer();

		doc.append(XmlUtils
				.startTag(ConstantesDigitalizacion.XML_SECURE_DIGITALIZATION_PARAMS));
		// IntegrationToken
		doc.append(XmlUtils
				.startTag(ConstantesDigitalizacion.XML_INTEGRATION_TOKEN));
		doc.append(XmlUtils.startCDATA());
		doc.append(this.getIntegrationToken());
		doc.append(XmlUtils.endCDATA());
		doc.append(XmlUtils
				.endTag(ConstantesDigitalizacion.XML_INTEGRATION_TOKEN));
		// urlADFileUpload
		doc.append(XmlUtils.createXMLTag(
				ConstantesDigitalizacion.XML_URL_ADD_FILE,
				this.getUrlADFileUpload()));
		// idSigningCertificate
		doc.append(XmlUtils.createXMLTag(
				ConstantesDigitalizacion.XML_ID_CERTIFICATE,
				this.getIdSigningCertificate()));
		// collate
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_COLLATE,
				Boolean.TRUE.toString()));
		// dokusiParams
		doc.append(XmlUtils
				.startTag(ConstantesDigitalizacion.XML_DOKUSI_PARAMS));
		// **documentalType
		doc.append(XmlUtils.createXMLTag(
				ConstantesDigitalizacion.XML_DOCUMENTAL_TYPE,
				this.getDocumentalType()));
		// **auditUser
		doc.append(XmlUtils.createXMLTag(
				ConstantesDigitalizacion.XML_AUDIT_USER, this.getAuditUser()));
		// **attributeList
		doc.append(XmlUtils
				.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE_LIST));
		// ****acl
		doc.append(XmlUtils.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_KEY,
				ConstantesDigitalizacion.XML_KEY_ACL));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_VALUE,
				this.getAcl()));
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		// ****ejgv_origen
		doc.append(XmlUtils.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_KEY,
				ConstantesDigitalizacion.XML_KEY_EJGV_ORIGEN));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_VALUE,
				this.getEjgvOrigen()));
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		// ****title
		doc.append(XmlUtils.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_KEY,
				ConstantesDigitalizacion.XML_KEY_TITLE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_VALUE,
				this.getTitle()));
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		// ****ejgv_serie
		doc.append(XmlUtils.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_KEY,
				ConstantesDigitalizacion.XML_KEY_EJGV_SERIE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_VALUE,
				this.getEjgvSerie()));
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		// ****object_name
		doc.append(XmlUtils.startTag(ConstantesDigitalizacion.XML_ATTRIBUTE));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_KEY,
				ConstantesDigitalizacion.XML_KEY_OBJECT_NAME));
		doc.append(XmlUtils.createXMLTag(ConstantesDigitalizacion.XML_VALUE,
				this.getObjectName()));
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE));

		// **attributeList
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_ATTRIBUTE_LIST));
		// dokusiParams
		doc.append(XmlUtils.endTag(ConstantesDigitalizacion.XML_DOKUSI_PARAMS));
		// urlResult
		doc.append(XmlUtils.createXMLTag(
				ConstantesDigitalizacion.XML_JAVASCRIPT_RESULT,
				this.getJavascriptResult()));

		doc.append(XmlUtils
				.endTag(ConstantesDigitalizacion.XML_SECURE_DIGITALIZATION_PARAMS));

		return doc.toString();
	}

}
